<?php
/**
 * Mercadopago Payments Module for Prestashop
 *
 * @author    Rinku Kazeno <development@kazeno.co>
 *
 * @copyright Copyright (c) 2012-2015, Rinku Kazeno
 * @license   This module is licensed to the user, upon purchase
 *  from either Prestashop Addons or directly from the author,
 *  for use on a single commercial Prestashop install, plus an
 *  optional separate non-commercial install (for development/testing
 *  purposes only). This license is non-assignable and non-transferable.
 *  To use in additional Prestashop installations an additional
 *  license of the module must be purchased for each one.
 *
 *  The user may modify the source of this module to suit their
 *  own business needs, as long as no distribution of either the
 *  original module or the user-modified version is made.
 *
 * @file-version 0.3
 */

function upgrade_module_1_28() {
  // Process Module upgrade to API 2.0
  return (
    Configuration::deleteByName(Mercadopago::CONFIG_PREFIX.'_MERCHANT_ID') AND
    Configuration::deleteByName(Mercadopago::CONFIG_PREFIX.'_SECRET') AND
    Configuration::deleteByName(Mercadopago::CONFIG_PREFIX.'_IPN_KEY') AND
    Configuration::updateValue(Mercadopago::CONFIG_PREFIX.'_CLIENT_ID', '0') AND
    Configuration::updateValue(Mercadopago::CONFIG_PREFIX.'_CLIENT_SECRET', '') AND
    Configuration::updateValue(Mercadopago::CONFIG_PREFIX.'_TOKEN_KEY', '') AND
    Configuration::updateValue(Mercadopago::CONFIG_PREFIX.'_TOKEN_DATE', '') AND
    Configuration::updateValue(Mercadopago::CONFIG_PREFIX.'_PAYMENT_METHODS', '["account_money","credit_card","debit_card","ticket","bank_transfer","atm"]') AND
    Configuration::updateValue(Mercadopago::CONFIG_PREFIX.'_CHECKOUT_TYPE', 'modal') AND
    Configuration::updateValue(Mercadopago::CONFIG_PREFIX.'_INSTALLMENTS', '')
  );
}

?>